---
title: Abbreviations · Cloudflare Style Guide
description: Abbreviations include acronyms, initialisms, shortened words, and
  contractions (in most contexts, the technical distinction between acronyms and
  initialisms is not relevant; it is fine to use the word acronym to refer to
  both).
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/abbreviations/
  md: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/abbreviations/index.md
---

Abbreviations include acronyms, initialisms, shortened words, and contractions (in most contexts, the technical distinction between acronyms and initialisms is not relevant; it is fine to use the word *acronym* to refer to both).

## Long and short versions of a word

Some words have a long version and a short version, such as "application" and "app", "demonstration" and "demo", "synchronize" and "sync".

The short versions of the words are not abbreviations, and if you use them, you do not need to put a period after them.

If you are not sure whether a word is an abbreviation or just a short version of a longer word, here is a list of [common abbreviations](https://abbreviations.yourdictionary.com/articles/list-of-commonly-used-abbreviations.html). If that does not settle the issue, use the speaking test: if you speak the short version as a word ("This is a demo version of the product"), you can usually treat it as a word and not an abbreviation.

If a standard term in the Cloudflare dashboard is the long version of a word, use that over the shorter version to maintain consistency and distinctions. For example, customer *applications* on Cloudflare for Teams are not shortened to *apps*. Depending on the use case, application might be the preferred term, especially due to translation.

## When to spell out a term

In general, when an abbreviation is likely to be unfamiliar to the audience, spell out the first mention of the term and immediately follow with the abbreviation, in parentheses. For all subsequent mentions of the abbreviation, use the abbreviation by itself.

If the first mention of a term occurs in a heading or title, you can use the abbreviation and then spell out the abbreviation in the first paragraph that follows the heading or title.

When deciding to spell out a term, consider your audience. If the majority of your audience is likely to recognize and understand the term, then you do not need to spell it out. For example, if you are writing documentation for developers that references an API, you do not need to spell out *application programming interface*. However, if you are explaining the general concept of an API to someone with no programming experience, spelling out the abbreviation can be helpful.

In some cases, spelling out a term does not help the reader understand the term. For example, writing out *portable document format* does not help the reader understand what a PDF document is. In those cases, do not spell out the term.

The following abbreviations rarely need to be spelled out:

* API
* DVD
* File formats such as PDF or XML
* HTML
* PC
* RAM
* REST
* Units of measure such as MB or GB
* URL
* USB

## Abbreviations not to use

Prefer English terms over Latin abbreviations. Do not use i.e. or e.g. Instead, use **that is** or **for example**, respectively.

One exception: avoid both *etc.* and *and so on* wherever possible, but if you really need to use one, use *etc.* Always include the period, even if a comma follows immediately after.

Do not use Internet slang abbreviations such as tl;dr, IMO, FYI, or others.

Use the most common form of a word. If the full spelled-out word is common and easily understandable, use that rather than abbreviating. For example, write approximately instead of approx. and versus instead of vs.

### Periods with abbreviations

Follow these guidelines:

* Do not use periods with acronyms or initialisms.
* Put a period at the end of a shortened word, except for date and time abbreviations.
* If you write or say an abbreviation as a word (for example, app or sync), do not put a period after it.
* Do not use a period with an abbreviation for the name of a country, US state, or the District of Columbia (DC).

## i.e. vs e.g.

While similar, these two Latin abbreviations carry very different meanings.

* **i.e.** stands for **id est**. Quite literally, it means "that is" (that = id, est = is). It can be replaced with "that is" or "in other words".
  * The median compression ratio achieved by Gzip was 0.65% (**i.e.**, the page was reduced to 0.65% of its size).
* **e.g.** stands for **exempli gratia**. Use this when introducing examples for something you have just mentioned. It can be replaced with "for example", or "like".
  * Cloudflare products (**e.g.**, Zero Trust, Magic Transit, etc.) offer network security and reliability.
