---
title: Zone lockdown migration guide · Cloudflare Smart Shield docs
description: Currently, any Cloudflare customer on a paid plan can configure
  Health Checks against any host or IP. Zone Lockdown specifies a list of one or
  more IP addresses, CIDR ranges, or networks that are the only IPs allowed to
  access a domain, subdomain, or URL. It allows multiple destinations in a
  single rule as well as IPv4 and IPv6 addresses. IP addresses not specified in
  the Zone Lockdown rule are denied access to the specified resources.
lastUpdated: 2025-09-17T12:18:58.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/smart-shield/configuration/health-checks/zone-lockdown/
  md: https://developers.cloudflare.com/smart-shield/configuration/health-checks/zone-lockdown/index.md
---

Currently, any Cloudflare customer on a paid plan can configure Health Checks against any host or IP. [Zone Lockdown](https://developers.cloudflare.com/waf/tools/zone-lockdown/) specifies a list of one or more IP addresses, CIDR ranges, or networks that are the only IPs allowed to access a domain, subdomain, or URL. It allows multiple destinations in a single rule as well as IPv4 and IPv6 addresses. IP addresses not specified in the Zone Lockdown rule are denied access to the specified resources.

Customers who use zone lockdown and want their health checks to continue passing can follow the guide below to bypass zone lockdown.

## Bypass zone lockdown

To bypass zone lockdown using a WAF custom rule:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account and domain.
2. Go to **Security** > **WAF** > **Custom rules**.
3. Select **Create rule**.
4. Create a custom rule matching on **user agent**.
5. Set the action to *Skip* and the corresponding feature to **Zone Lockdown** under **More components to skip**.

Cloudflare Health Checks have a user agent of the following format: `Mozilla/5.0 (compatible;Cloudflare-Healthchecks/1.0;+https://www.cloudflare.com/; healthcheck-id: XXX)` where `XXX` is replaced with the first 16 characters of the Health Check ID.

To allow a specific Health Check, verify if the user agent contains the first 16 characters of the Health Check ID.

### Via the API

This example adds a new WAF custom rule to the ruleset with ID `{ruleset_id}` that skips zone lockdown for incoming requests with a user agent containing `1234567890abcdef`:

```bash
curl "https://api.cloudflare.com/client/v4/{zone_id}/rulesets/{ruleset_id}/rules" \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data '{
  "action": "skip",
  "action_parameters": {
    "products": [
      "zoneLockdown"
    ]
  },
  "expression": "http.user_agent contains \"1234567890abcdef\"",
  "description": "bypass zone lockdown - specific healthcheck"
}'
```
