---
title: Content-based asset creation · Cloudflare Reference Architecture docs
description: AI systems combine text-generation and text-to-image models to
  create visual content from text. They generate prompts, moderate content, and
  produce images for various applications.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-asset-creation/
  md: https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-asset-creation/index.md
---

Combining text-generation models with text-to-image models can lead to powerful AI systems capable of generating visual content based on input prompts. This integration can be achieved through a collaborative framework where a text-generation model generates prompts for the text-to-image model based on input text.

Here's how the process can work:

* Input Text Processing: The input text is provided to the system, which can be anything from a simple sentence to multiple paragraphs. This text serves as the basis for generating visual content.

* Prompt Generation: The text-generation model generates prompts based on the input text. These prompts are specifically crafted to guide the text-to-image model in generating images that are contextually relevant to the input text. The prompts can include descriptions, keywords, or other cues to guide the image generation process.

* Content Moderation: Text-classification models can be employed to ensure that the generated assets comply with content policies

* Text-to-Image Model: A text-to-image model takes the prompts generated by the text-generation model as input and produces corresponding images. The text-to-image model learns to translate textual descriptions into visual representations, aiming to capture the essence and context conveyed by the input text.

Example uses of such compositions of AI models can be employed to generation visual assets for marketing, publishing, presentations, and more.

## Asset generation

![Figure 1 asset generation](https://developers.cloudflare.com/_astro/ai-asset-generation.BN6tfVXY_2g5MiU.svg)

1. **Client upload**: Send POST request with content to API endpoint.
2. **Prompt generation**: Generate prompt for later-stage text-to-image model by calling [Workers AI](https://developers.cloudflare.com/workers-ai/) [text generation models](https://developers.cloudflare.com/workers-ai/models/) with content as input.
3. **Safety check**: Check for compliance with safety guidelines by calling [Workers AI](https://developers.cloudflare.com/workers-ai/) [text classification models](https://developers.cloudflare.com/workers-ai/models/) with the previously generated prompt as input.
4. **Image generation**: Generate image by calling [Workers AI](https://developers.cloudflare.com/workers-ai/) [text-to-image models](https://developers.cloudflare.com/workers-ai/models/) previously generated prompt.

## Related resources

* [Community project: content-based asset creation demo](https://auto-asset.pages.dev/)
* [Workers AI: Text generation models](https://developers.cloudflare.com/workers-ai/models/)
* [Workers AI: Text-to-image models](https://developers.cloudflare.com/workers-ai/models/)
* [Workers AI: llamaguard-7b-awq](https://developers.cloudflare.com/workers-ai/models/llamaguard-7b-awq/)
